/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.hyperlink.IJSHyperlink;
import com.aptana.editor.js.hyperlink.JSHyperlinkUtil;
import com.aptana.editor.js.hyperlink.JSSearchStringHyperlink;
import com.aptana.editor.js.hyperlink.JSTargetRegionHyperlink;
import com.aptana.editor.js.internal.JSModelUtil;
import com.aptana.index.core.Index;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.CommonJSResolver;
import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.RequireResolverFactory;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSHyperlinkCollector
extends JSTreeWalker {
    private AbstractThemeableEditor editor;
    private JSParseRootNode ast;
    private int offset;
    private Set<IJSHyperlink> hyperlinks = new TreeSet<IJSHyperlink>();
    private JSIndexQueryHelper indexHelper;

    public JSHyperlinkCollector(AbstractThemeableEditor editor, JSParseRootNode ast, int offset) {
        this.editor = editor;
        this.ast = ast;
        this.offset = offset;
        this.hyperlinks = new TreeSet<IJSHyperlink>(new Comparator<IJSHyperlink>(){

            @Override
            public int compare(IJSHyperlink o1, IJSHyperlink o2) {
                return o1.getTargetFilePath().compareTo(o2.getTargetFilePath());
            }
        });
    }

    protected void addHyperlink(IJSHyperlink link) {
        if (link != null) {
            this.hyperlinks.add(link);
        }
    }

    protected void addHyperlink(JSIdentifierNode linkNode, JSNode targetNode, String linkType) {
        if (linkNode != targetNode) {
            IRegion hyperlinkRegion = this.getNodeRegion((JSNode)linkNode);
            URI projectURI = EditorUtil.getProjectURI((AbstractThemeableEditor)this.editor);
            String targetFilePath = EditorUtil.getURI((IEditorPart)this.editor).toString();
            String hyperlinkText = JSHyperlinkUtil.getDocumentDisplayName(projectURI, targetFilePath);
            IRegion targetRegion = this.getNodeRegion(targetNode);
            this.addHyperlink(new JSTargetRegionHyperlink(hyperlinkRegion, linkType, hyperlinkText, targetFilePath, targetRegion));
        }
    }

    public Collection<IJSHyperlink> getHyperlinks() {
        return this.hyperlinks;
    }

    protected String getLinkType(JSIdentifierNode node) {
        String result = "";
        IParseNode parent = node.getParent();
        if (parent instanceof JSNode) {
            switch (parent.getNodeType()) {
                case 48: {
                    if (parent.getFirstChild().getNodeType() != 62) break;
                    result = "invocation";
                    break;
                }
                case 62: {
                    result = "invocation";
                    break;
                }
                default: {
                    result = "variable";
                }
            }
        }
        return result;
    }

    protected IRegion getNodeRegion(JSNode node) {
        int start = node.getStart();
        int length = node.getLength();
        if (node.getSemicolonIncluded()) {
            --length;
        }
        return new Region(start, length);
    }

    protected void processEditorSymbols(JSIdentifierNode node) {
        if (node.getParent() instanceof JSInvokeNode && node.getNameNode().getName().equals("require")) {
            URI editorURI;
            IPath currentDirectory;
            IProject project;
            JSInvokeNode invoke = (JSInvokeNode)node.getParent();
            JSArgumentsNode args = invoke.getArguments();
            String moduleId = this.getPath(args);
            IPath requiredFile = RequireResolverFactory.resolve((String)moduleId, (IProject)(project = EditorUtil.getProject((AbstractThemeableEditor)this.editor)), (IPath)(currentDirectory = Path.fromPortableString((String)(editorURI = EditorUtil.getURI((IEditorPart)this.editor)).getPath()).removeLastSegments(1)), (IPath)project.getLocation());
            if (requiredFile != null && requiredFile.toFile().exists()) {
                IRegion hyperlinkRegion = this.getNodeRegion((JSNode)node);
                String targetFilePath = requiredFile.toFile().toURI().toASCIIString();
                String hyperlinkText = JSHyperlinkUtil.getDocumentDisplayName(project.getLocationURI(), targetFilePath);
                this.addHyperlink(new JSTargetRegionHyperlink(hyperlinkRegion, "invocation", hyperlinkText, targetFilePath, (IRegion)new Region(0, 0)));
            }
            return;
        }
        JSScope globalScope = this.ast.getGlobals();
        JSScope activeScope = globalScope.getScopeAtOffset(this.offset);
        JSPropertyCollection properties = activeScope.getSymbol(node.getText());
        if (properties != null) {
            block4: for (JSNode value : properties.getValues()) {
                IParseNode parent = value.getParent();
                switch (parent.getNodeType()) {
                    case 69: {
                        this.addHyperlink(node, value, "parameter");
                        break;
                    }
                    case 63: {
                        if (parent.contains(node.getStartingOffset())) continue block4;
                        JSNode targetIdentifier = (JSNode)value.getParent().getFirstChild();
                        this.addHyperlink(node, targetIdentifier, "local declaration");
                        break;
                    }
                    default: {
                        JSFunctionNode functionNode;
                        IParseNode name;
                        JSNode targetIdentifier;
                        if (value.getNodeType() == 1) {
                            targetIdentifier = (JSNode)value.getFirstChild();
                            this.addHyperlink(node, targetIdentifier, "local assignment");
                            break;
                        }
                        if (value.getNodeType() != 70 || !((name = (functionNode = (JSFunctionNode)value).getName()) instanceof JSNode)) continue block4;
                        this.addHyperlink(node, (JSNode)name, "");
                    }
                }
            }
        }
    }

    private String getPath(JSArgumentsNode args) {
        if (args.getChildCount() > 0) {
            IParseNode child = args.getChild(0);
            return CommonJSResolver.getModuleId((IParseNode)child);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processProjectGlobals(JSIdentifierNode node) {
        IParseNode parent = node.getParent();
        boolean valid = false;
        if (parent instanceof JSParseRootNode) {
            valid = true;
        } else if (parent instanceof JSNode) {
            block0 : switch (parent.getNodeType()) {
                case 21: 
                case 61: 
                case 62: 
                case 75: 
                case 85: {
                    valid = true;
                    break;
                }
                case 48: {
                    IParseNode grandparent;
                    IParseNode iParseNode = grandparent = parent != null ? parent.getParent() : null;
                    if (node.getIndex() == 0 || parent != null && grandparent != null && grandparent.getNodeType() == 48) {
                        valid = true;
                        break;
                    }
                    while (true) {
                        if (parent == null || parent.getNodeType() != 48) {
                            if (parent != null && parent.getNodeType() == 1) break block0;
                            valid = true;
                            break block0;
                        }
                        parent = parent.getParent();
                    }
                }
            }
        }
        if (!valid) return;
        JSLocationIdentifier identifier = new JSLocationIdentifier(this.offset, (IParseNode)node);
        this.ast.accept((JSTreeWalker)identifier);
        LocationType type = identifier.getType();
        switch (type) {
            case IN_PROPERTY_NAME: {
                JSGetPropertyNode propertyNode = ParseUtil.getGetPropertyNode(identifier.getTargetNode(), identifier.getStatementNode());
                this.processProperty(node, propertyNode);
                return;
            }
            case IN_VARIABLE_NAME: {
                this.processVariable(node);
                return;
            }
        }
    }

    protected void processProperty(JSIdentifierNode node, JSGetPropertyNode propertyNode) {
        URI editorURI;
        Index index;
        ArrayList<PropertyElement> elements = new ArrayList<PropertyElement>();
        JSIndexQueryHelper queryHelper = this.createQueryHelper();
        List<String> types = ParseUtil.getReceiverTypeNames(queryHelper, index = EditorUtil.getIndex((AbstractThemeableEditor)this.editor), editorURI = EditorUtil.getURI((IEditorPart)this.editor), (IParseNode)node, propertyNode, this.offset);
        if (!CollectionsUtil.isEmpty(types)) {
            for (String typeName : types) {
                Collection members = queryHelper.getTypeMembers(typeName, node.getText());
                elements.addAll(members);
            }
        }
        this.processPropertyElements(elements, node);
    }

    protected synchronized JSIndexQueryHelper createQueryHelper() {
        if (this.indexHelper == null) {
            this.indexHelper = JSModelUtil.createQueryHelper(this.editor);
        }
        return this.indexHelper;
    }

    protected void processPropertyElements(Collection<PropertyElement> elements, JSIdentifierNode node) {
        URI projectURI = EditorUtil.getProjectURI((AbstractThemeableEditor)this.editor);
        IRegion region = this.getNodeRegion((JSNode)node);
        String linkType = this.getLinkType(node);
        boolean isLoggingEnabled = IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_open_declaration_types");
        for (PropertyElement element : elements) {
            List documents;
            if (isLoggingEnabled) {
                IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)("Hyperlink type model element: " + element.toSource()), (String)"com.aptana.editor.js/debug/show_open_declaration_types");
            }
            if (CollectionsUtil.isEmpty((Collection)(documents = element.getDocuments()))) continue;
            if (isLoggingEnabled) {
                IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)("Hyperlink type model documents: " + StringUtil.join((String)", ", (Collection)documents)), (String)"com.aptana.editor.js/debug/show_open_declaration_types");
            }
            String elementName = element.getName();
            for (String document : documents) {
                if (projectURI != null && !JSHyperlinkUtil.isInCurrentProject(projectURI, document)) continue;
                String text = JSHyperlinkUtil.getDocumentDisplayName(projectURI, document);
                this.addHyperlink(new JSSearchStringHyperlink(region, linkType, text, document, elementName));
            }
        }
    }

    protected void processVariable(JSIdentifierNode node) {
        JSIndexQueryHelper queryHelper = this.createQueryHelper();
        Collection elements = queryHelper.getGlobals(EditorUtil.getFileName((IEditorPart)this.editor), node.getText());
        this.processPropertyElements(elements, node);
    }

    public void visit(JSIdentifierNode node) {
        if (node.contains(this.offset)) {
            this.processEditorSymbols(node);
            this.processProjectGlobals(node);
        }
    }

    public void visit(JSParseRootNode node) {
        if (node.contains(this.offset)) {
            for (IParseNode child : node) {
                if (!child.contains(this.offset)) continue;
                if (!(child instanceof JSNode)) break;
                ((JSNode)child).accept((JSTreeWalker)this);
                break;
            }
        }
    }

    protected void visitChildren(JSNode node) {
        if (node.contains(this.offset)) {
            for (IParseNode child : node) {
                if (!child.contains(this.offset)) continue;
                if (!(child instanceof JSNode)) break;
                ((JSNode)child).accept((JSTreeWalker)this);
                break;
            }
        }
    }
}

